//#define NODDRAW
#include "..\plugins.h"
#include "malloc.h"

//the hq4x_xx funcs don't perform sequential vidmem writes, so that causes a reduced performance
//#define DIRECTVIDEOWRITE	

void hq4x_16(unsigned short *in,unsigned short *out,unsigned int width,unsigned int height,unsigned int pitch,unsigned int xpitch);
void hq4x_32(unsigned short *in,unsigned short *out,unsigned int width,unsigned int height,unsigned int pitch,unsigned int xpitch);
unsigned int   LUT16to32[65536];
unsigned int   RGBtoYUV[65536];
char bit32;
unsigned char *Buffer=0;

void Init(HWND Parent, char Is555,char Is32bit,char Rotated)
{
  int i, j, k, r, g, b, Y, u, v;

  for (i=0; i<65536; i++)
    LUT16to32[i] = ((i & 0xF800) << 8) + ((i & 0x07E0) << 5) + ((i & 0x001F) << 3);

  for (i=0; i<32; i++)
  for (j=0; j<64; j++)
  for (k=0; k<32; k++)
  {
    r = i << 3;
    g = j << 2;
    b = k << 3;
    Y = (r + g + b) >> 2;
    u = 128 + ((r - b) >> 2);
    v = 128 + ((-r + 2*g -b)>>3);
    RGBtoYUV[ (i << 11) + (j << 5) + k ] = (Y<<16) + (u<<8) + v;
  }
  bit32=Is32bit;
  if(Buffer)
		free(Buffer);
	Buffer=0;
}

unsigned int SetWidth(unsigned short width)
{
    if(Buffer)
		free(Buffer);
	Buffer=0;
	return 4*width;
}

unsigned int SetHeight(unsigned short height)
{
	if(Buffer)
		free(Buffer);
	Buffer=0;
    return 4*height;
}

void Blit(unsigned short width,unsigned short height,unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned int *palette32)
{
#ifdef DIRECTVIDEOWRITE
	if(bit32)
		hq4x_32(src,dstr,width,height,dstpitch,srcpitch);
	else
		hq4x_16(src,dstr,width,height,dstpitch,srcpitch);
#else
	if(!Buffer)
	{
		if(bit32)
		{
			Buffer=malloc(width*4*height*4*4);
		}
		else
		{
			Buffer=malloc(width*4*height*4*2);
		}
	}
	if(bit32)
	{
		unsigned char *ptr=(unsigned char *) dst;
		unsigned char *s=Buffer;
		int i;
		hq4x_32(src,(unsigned short *) Buffer,width,height,width*4*4,srcpitch);
		for(i=0;i<height*4;++i)
		{
			memcpy(ptr,s,width*4*4);
			s+=width*4*4;
			ptr+=dstpitch;
		}
	}
	else
	{
		unsigned char *ptr=(unsigned char *) dst;
		unsigned char *s=Buffer;
		int i;
		hq4x_16(src,(unsigned short *) Buffer,width,height,width*4*2,srcpitch);
		for(i=0;i<height*4;++i)
		{
			memcpy(ptr,s,width*4*2);
			s+=width*4*2;
			ptr+=dstpitch;
		}
	}
#endif
}

void Terminate()
{
   if(Buffer)
		free(Buffer);
	Buffer=0;
}

struct _PluginInfo PluginInfo=
{
    PLUGINVER,
    VIDEOPLUGIN,
    "HQ4x",
    "Maxim Stepin",
    "http://www.hiend3d.com/hq4x.html",
    1,
    0,
	//VideoInterface
    SUPPORTS16BIT|SUPPORTS32BIT,
	Init,
	SetWidth,
	SetHeight,
	Blit,
    NULL,
    Terminate
};


struct _PluginInfo __declspec(dllexport) * __cdecl GetInterface()
{
	return &PluginInfo;
}
